/**
 * Sentinel Privacy JavaScript
 * 
 * Handles data deletion request form functionality
 */

jQuery(document).ready(function($) {
    // Handle data deletion request form submission
    $('#sentinel-deletion-request-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $message = $('#sentinel-form-message');
        var $submitBtn = $form.find('button[type="submit"]');
        var originalButtonText = $submitBtn.text();
        
        // Disable form during submission
        $form.find('input, select, textarea, button').prop('disabled', true);
        $submitBtn.text('Submitting...');
        
        // Clear previous messages
        $message.removeClass('sentinel-success sentinel-error').hide();
        
        // Submit via AJAX
        $.ajax({
            url: sentinelPrivacyAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'sentinel_submit_deletion_request',
                nonce: $('#sentinel_deletion_nonce').val(),
                reason: $('#deletion_reason').val(),
                details: $('#deletion_details').val(),
                confirm: $('#confirm_deletion').is(':checked')
            },
            success: function(response) {
                if (response.success) {
                    $message.addClass('sentinel-success').html(response.data.message).show();
                    $form[0].reset();
                } else {
                    $message.addClass('sentinel-error').html(response.data.message).show();
                }
            },
            error: function() {
                $message.addClass('sentinel-error').html('An error occurred. Please try again.').show();
            },
            complete: function() {
                // Re-enable form
                $form.find('input, select, textarea, button').prop('disabled', false);
                $submitBtn.text(originalButtonText);
            }
        });
    });
}); 