<?php
/**
 * Uninstall Sentinel Plugin
 * 
 * This file is executed when the plugin is deleted from WordPress.
 * It removes all plugin data including database tables and options.
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Include WordPress database functions
require_once(ABSPATH . 'wp-admin/includes/upgrade.php');

// Get database prefix
global $wpdb;

// Remove database tables
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}sentinel_logs");
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}sentinel_events");
$wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}sentinel_archive");

// Remove plugin options
delete_option('sentinel_settings');
delete_option('sentinel_version');
delete_option('sentinel_db_version');

// Clear any cached data
wp_cache_flush(); 