<?php
/**
 * Sentinel Email HTML Template
 *
 * Usage: In the parent file, set the following variables:
 *   - $event_config (array): Event configuration (label, category, priority, etc.)
 *   - $data (array): Event data
 *   - $to (string): Recipient email
 *   - $subject (string): Email subject
 *   - $is_notification (bool): True for granular notification, false for security/system/critical
 *   - $event_key (string): The event key
 *
 * This file will set $body_html (string) for use in email/debug logging.
 */

// --- Color logic for priority and category ---
$priority_color = '';
$priority_bg = '';
switch ($event_config['priority']) {
    case 'critical': $priority_color = '#dc2626'; $priority_bg = '#fef2f2'; break;
    case 'high': $priority_color = '#ea580c'; $priority_bg = '#fff7ed'; break;
    case 'medium': $priority_color = '#ca8a04'; $priority_bg = '#fefce8'; break;
    default: $priority_color = '#2563eb'; $priority_bg = '#eff6ff';
}
$category_color = '';
switch ($event_config['category']) {
    case 'security': $category_color = '#dc2626'; break;
    case 'system': $category_color = '#059669'; break;
    default: $category_color = '#6b7280';
}

// --- Title and subtitle ---
$title = $is_notification ? 'Sentinel Notification' : 'Sentinel Alert';
$subtitle = 'WordPress Activity Monitoring System';

// --- Compose HTML body ---
$body_html = '<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>' . htmlspecialchars($title) . '</title>
<style>body { font-family: -apple-system, BlinkMacSystemFont, \"Segoe UI\", Roboto, \"Helvetica Neue\", Arial, sans-serif; line-height: 1.6; color: #374151; margin: 0; padding: 0; background-color: #f9fafb; } .container { max-width: 600px; margin: 0 auto; background-color: #ffffff; box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1); } .header { background: #fff; color: #23282d; padding: 24px 24px 10px 24px; text-align: center; border-bottom: 1px solid #e5e7eb; } .header img { max-height: 56px; width: auto; margin-bottom: 10px; display: block; margin-left: auto; margin-right: auto; } .header h1 { margin: 0; font-size: 22px; font-weight: 700; letter-spacing: 0.5px; color: #23282d; } .header p { margin: 8px 0 0 0; opacity: 0.85; font-size: 13px; color: #6b7280; } .content { padding: 30px; } .alert-box { background-color: ' . $priority_bg . '; border-left: 4px solid ' . $priority_color . '; padding: 20px; margin-bottom: 25px; border-radius: 0 8px 8px 0; } .alert-title { font-size: 18px; font-weight: 600; color: ' . $priority_color . '; margin: 0 0 15px 0; } .info-grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; margin-bottom: 25px; } .info-item { background-color: #f8fafc; padding: 15px; border-radius: 8px; border: 1px solid #e5e7eb; word-break: break-all; overflow-wrap: anywhere; } .info-label { font-size: 12px; font-weight: 600; text-transform: uppercase; color: #6b7280; margin-bottom: 5px; letter-spacing: 0.5px; } .info-value { font-size: 14px; font-weight: 500; color: #111827; word-break: break-all; overflow-wrap: anywhere; } .priority-badge { display: inline-block; background-color: ' . $priority_color . '; color: white; padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; } .category-badge { display: inline-block; background-color: ' . $category_color . '; color: white; padding: 4px 12px; border-radius: 20px; font-size: 12px; font-weight: 600; text-transform: uppercase; letter-spacing: 0.5px; } .data-section { background-color: #f8fafc; border: 1px solid #e5e7eb; border-radius: 8px; padding: 20px; margin-top: 20px; } .data-title { font-size: 14px; font-weight: 600; color: #374151; margin: 0 0 10px 0; } .data-content { background-color: #ffffff; border: 1px solid #d1d5db; border-radius: 4px; padding: 15px; font-family: \"Courier New\", monospace; font-size: 12px; line-height: 1.4; color: #374151; overflow-x: auto; white-space: pre-wrap; word-break: break-all; overflow-wrap: anywhere; } .footer { background-color: #f8fafc; border-top: 1px solid #e5e7eb; padding: 20px; text-align: center; } .footer p { margin: 0; font-size: 12px; color: #6b7280; word-break: break-all; overflow-wrap: anywhere; } .footer a { color: #3b82f6; text-decoration: none; } .footer a:hover { text-decoration: underline; } @media (max-width: 600px) { .info-grid { grid-template-columns: 1fr; gap: 15px; } .content { padding: 20px; } .header { padding: 16px 8px 8px 8px; } } </style>
</head>
<body>
<div class="container">
<div class="header">
<img src="https://www.justpsntrophies.com/wp-content/themes/jpsnt/img/Sentinel.png" alt="Sentinel Logo" />
<h1>' . htmlspecialchars($title) . '</h1>
<p>' . htmlspecialchars($subtitle) . '</p>
</div><div class="content">
<div class="alert-box">
<div class="alert-title">' . htmlspecialchars($event_config['label'] ?? $event_key) . '</div>
<p style="margin: 0; color: #6b7280; font-size: 14px;">A ' . htmlspecialchars($event_config['category']) . ' event has been detected and logged by Sentinel.</p>
</div>
<div class="info-grid">
<div class="info-item">
<div class="info-label">Event Type</div>
<div class="info-value">' . htmlspecialchars($event_config['label'] ?? $event_key) . '</div>
</div>
<div class="info-item">
<div class="info-label">Category</div>
<div class="info-value">
<span class="category-badge">' . htmlspecialchars($event_config['category']) . '</span>
</div>
</div>
<div class="info-item">
<div class="info-label">Priority</div>
<div class="info-value">
<span class="priority-badge">' . htmlspecialchars($event_config['priority']) . '</span>
</div>
</div>
<div class="info-item">
<div class="info-label">User ID</div>
<div class="info-value">' . (get_current_user_id() ?: 'N/A') . '</div>
</div>
<div class="info-item">
<div class="info-label">Time</div>
<div class="info-value">' . htmlspecialchars(current_time('mysql')) . '</div>
</div>
<div class="info-item">
<div class="info-label">URL</div>
<div class="info-value">' . htmlspecialchars($_SERVER['REQUEST_URI'] ?? 'Unknown') . '</div>
</div>
</div>
<div class="data-section">
<div class="data-title">Event Data</div>
<div class="data-content">' . htmlspecialchars(print_r($data, true)) . '</div>
</div>
</div>
<div class="footer">
<p>This alert was generated by <a href="http://www.getsentinel.dev/">Sentinel</a> - WordPress Activity Logger</p>
<p>Sent to: ' . htmlspecialchars($to) . '</p>
</div>
</div>
</body>
</html>';
// $body_html is now available for use after including this file. 