<?php
/**
 * Sentinel Core Class
 * 
 * Main plugin class that handles initialization and coordination.
 */

// Prevent direct access - this is a security measure to ensure
// this file can only be loaded through WordPress
if (!defined('ABSPATH')) {
    exit;
}

class Sentinel {
    
    /**
     * Plugin version
     */
    private $version = '1.0.0';
    
    /**
     * Singleton instance
     */
    private static $instance = null;
    
    /**
     * Constructor
     */
    private function __construct() {
        $this->init_hooks();
    }
    
    /**
     * Get singleton instance
     */
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    /**
     * Initialize WordPress hooks
     */
    private function init_hooks() {
        add_action('admin_menu', array($this, 'add_admin_menu'));
    }
    
    /**
     * Add admin menu items
     */
    public function add_admin_menu() {
        add_menu_page(
            'Sentinel',
            'Sentinel',
            'manage_options',
            'sentinel-logs',
            array($this, 'render_logs_page'),
            'dashicons-shield',
            30
        );
    }
    
    /**
     * Render the logs page
     */
    public function render_logs_page() {
        include plugin_dir_path(__FILE__) . '../admin/views/logs.php';
    }
    
    /**
     * Register a custom event
     */
    public function register_custom_event($event_key, $args = array()) {
        // Placeholder for event registration
    }
} 