/**
 * Sentinel Admin JavaScript
 * 
 * General JavaScript for the Sentinel admin interface functionality.
 * Settings page functionality is handled separately by sentinel-settings.js
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        
        // General admin functionality that applies to all Sentinel pages
        
        // Auto-dismiss admin notices after 5 seconds
        $('.notice.is-dismissible').each(function() {
            var notice = $(this);
            setTimeout(function() {
                notice.fadeOut();
            }, 5000);
        });
        
        // Confirmation dialogs for destructive actions
        $('.sentinel-confirm-action').on('click', function(e) {
            var message = $(this).data('confirm') || 'Are you sure you want to perform this action?';
            if (!confirm(message)) {
                e.preventDefault();
                return false;
            }
        });
        
        // Loading states for async actions
        $('.sentinel-async-action').on('click', function() {
            var button = $(this);
            var originalText = button.text();
            
            button.text('Loading...').prop('disabled', true);
            
            // Re-enable after 30 seconds as a failsafe
            setTimeout(function() {
                button.text(originalText).prop('disabled', false);
            }, 30000);
        });
        
        // Copy to clipboard functionality
        $('.sentinel-copy-to-clipboard').on('click', function(e) {
            e.preventDefault();
            
            var target = $(this).data('target');
            var text = $(target).text() || $(target).val();
            
            if (navigator.clipboard) {
                navigator.clipboard.writeText(text).then(function() {
                    // Show temporary success message
                    var button = $(e.target);
                    var originalText = button.text();
                    button.text('Copied!');
                    setTimeout(function() {
                        button.text(originalText);
                    }, 2000);
                });
            }
        });
        
        // Toggle visibility for collapsible sections
        $('.sentinel-toggle-section').on('click', function(e) {
            e.preventDefault();
            
            var target = $(this).data('target');
            var section = $(target);
            var icon = $(this).find('.dashicons');
            
            section.slideToggle();
            
            // Toggle icon between down and up arrows
            if (icon.hasClass('dashicons-arrow-down')) {
                icon.removeClass('dashicons-arrow-down').addClass('dashicons-arrow-up');
            } else {
                icon.removeClass('dashicons-arrow-up').addClass('dashicons-arrow-down');
            }
        });
        
    });
    
    // BEGIN: Email Notification Settings Toggle Logic (with fade-in)
    jQuery(document).ready(function($) {
        var mainToggle = document.getElementById('sentinel_email_notifications_enabled');
        var optionsDiv = document.getElementById('sentinel_email_notification_options');
        if (mainToggle && optionsDiv) {
            // Set initial state
            if (mainToggle.checked) {
                optionsDiv.classList.add('is-visible');
            } else {
                optionsDiv.classList.remove('is-visible');
            }
            mainToggle.addEventListener('change', function() {
                if (this.checked) {
                    optionsDiv.classList.add('is-visible');
                } else {
                    optionsDiv.classList.remove('is-visible');
                }
            });
        }
    });
    // END: Email Notification Settings Toggle Logic (with fade-in)
    
})(jQuery); 